unit Upl_dlg5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  DBCtrls, Grids, DBGrids, StdCtrls, Buttons,
  ExtCtrls, Db,
{$IFNDEF VER90}
  DBFilter,
{$ENDIF}
  DBTables;

type
  TSelectDSPFileDlg = class(TForm)
    Panel1: TPanel;
    CloseOKBtn: TBitBtn;
    DBNavigator1: TDBNavigator;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    Panel2: TPanel;
    Panel5: TPanel;
    LoadSQLBtn: TSpeedButton;
    SaveSQLBtn: TSpeedButton;
    Panel3: TPanel;
    Label1: TLabel;
    SQLEdit: TMemo;
    DBGrid1: TDBGrid;
    RunSQLBtn: TSpeedButton;
    procedure LoadSQLBtnClick(Sender: TObject);
    procedure SaveSQLBtnClick(Sender: TObject);
    procedure RunSQLBtnClick(Sender: TObject);
    procedure CloseOKBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
  public
  end;

var
  SelectDSPFileDlg: TSelectDSPFileDlg;

implementation

uses DataModule;

{$R *.DFM}

procedure TSelectDSPFileDlg.LoadSQLBtnClick(Sender: TObject);
begin
  If OpenDialog1.Execute then
    SQLEdit.Lines.LoadFromFile(OpenDialog1.FileName);
end;

procedure TSelectDSPFileDlg.SaveSQLBtnClick(Sender: TObject);
begin
  If SaveDialog1.Execute then
    SQLEdit.Lines.SaveToFile(SaveDialog1.FileName);
end;

procedure TSelectDSPFileDlg.RunSQLBtnClick(Sender: TObject);
begin
  DM.QueryFile.Close;
  DM.QueryFile.SQL.Assign(SQLEdit.Lines);
  CloseOKBtn.Enabled:= false;
  DM.QueryFile.Open;
  if ( DM.QueryFile.FindField('FileName') <> nil ) and
     ( DM.QueryFile.FindField('DSPDir') <> nil )
   then CloseOKBtn.Enabled:= true;
end;

procedure TSelectDSPFileDlg.CloseOKBtnClick(Sender: TObject);

type
  DSError = ( dse_notopen, dse_nofield );
  procedure Error(ErrorID: DSError);
  var
    S: string;
  Begin
    case ErrorID of
      dse_notopen:
        S:= 'DataSet not opened';
      dse_nofield:
        S:= 'FileName filed of Files.DB not in query';
    end;
    Exception.Create(S);
  End;

begin
  if not DM.QueryFile.Active then
    raise Exception.Create('DataSet not opened');
  if ( DM.QueryFile.FindField('FileName') = nil )  then
    raise Exception.Create('FileName filed of Files.DB not in query');
  ModalResult:= mrOK;
end;

procedure TSelectDSPFileDlg.FormCreate(Sender: TObject);
begin
  // assign controls
  DBGrid1.DataSource:= DM.DSQueryFile;
  DBNavigator1.DataSource:= DM.DSQueryFile;
end;

procedure TSelectDSPFileDlg.FormDestroy(Sender: TObject);
begin
  // release assignments
  DBGrid1.DataSource:= nil;
  DBNavigator1.DataSource:= nil;
end;

end.
